//
//  MCSelectionListController.h
//  MCApplication
//
//  Created by Alykhan Jetha on Fri Jul 18 2003.
//  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
//

#import <AppKit/AppKit.h>

@class MCTableviewController;

@interface MCSelectionListController : NSObject {

	NSMutableArray 							*objects;
	NSArray									*choices;
	

	IBOutlet		MCTableviewController	*tvc;
	
	id										delegate;

	BOOL isMutable;
}

- (void)setDelegate:(id)deleg;
- (id)delegate;

- (id)model;
- (void)setModel:(id)aModel;
- (void)setModelNoUpdate:(id)aModel;

- (void)updateInterfaceFromModel;
- (void)updateModelFromInterface;

- (void)setSourceList:(NSArray *)array;

- (void)passMutabilityFlag:(BOOL)flag;
@end

@interface NSObject (MCSelectionListDelegate)

- (BOOL)selectionListController:(MCSelectionListController *)slc 
		didSelectObject:(id)object 
		shouldAddToArray:(NSMutableArray *)array;

- (BOOL)selectionListController:(MCSelectionListController *)slc 
		didUnselectedObject:(id)object 
		shouldRemoveFromArray:(NSMutableArray *)array;
		
- (BOOL)selectionListController:(MCSelectionListController *)slc
		shouldAllowEditOfColumn:(NSTableColumn *)tc
		object:(id)obj;

@end
